/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ShapeRoi;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Polygon;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;

public class ThresholdToSelection
implements PlugInFilter {
    ImagePlus image;
    ImageProcessor ip;
    float min;
    float max;
    int w;
    int h;

    public void run(ImageProcessor ip) {
        this.ip = ip;
        this.min = (float)ip.getMinThreshold();
        this.max = (float)ip.getMaxThreshold();
        this.w = ip.getWidth();
        this.h = ip.getHeight();
        this.image.setRoi(this.getShapeRoi());
    }

    final boolean selected(int x, int y) {
        float v = this.ip.getf(x, y);
        return v >= this.min && v <= this.max;
    }

    ShapeRoi getShapeRoi() {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        boolean[] prevRow = new boolean[this.w + 2];
        boolean[] thisRow = new boolean[this.w + 2];
        Outline[] outline = new Outline[this.w + 1];
        int y = 0;
        while (y <= this.h) {
            boolean[] b = prevRow;
            prevRow = thisRow;
            thisRow = b;
            int x = 0;
            while (x <= this.w) {
                int x1;
                thisRow[x + 1] = y < this.h && x < this.w ? this.selected(x, y) : false;
                if (thisRow[x + 1]) {
                    if (!prevRow[x + 1]) {
                        if (outline[x] == null) {
                            if (outline[x + 1] == null) {
                                outline[x + 1] = outline[x] = new Outline();
                                outline[x].push(x + 1, y);
                                outline[x].push(x, y);
                            } else {
                                outline[x] = outline[x + 1];
                                outline[x + 1] = null;
                                outline[x].push(x, y);
                            }
                        } else if (outline[x + 1] == null) {
                            outline[x + 1] = outline[x];
                            outline[x] = null;
                            outline[x + 1].shift(x + 1, y);
                        } else if (outline[x + 1] == outline[x]) {
                            polygons.add(outline[x].getPolygon());
                            outline[x + 1] = null;
                            outline[x] = null;
                        } else {
                            outline[x].shift(outline[x + 1]);
                            x1 = 0;
                            while (x1 <= this.w) {
                                if (x1 != x + 1 && outline[x1] == outline[x + 1]) {
                                    outline[x1] = outline[x];
                                    outline[x + 1] = null;
                                    outline[x] = null;
                                    break;
                                }
                                ++x1;
                            }
                            if (outline[x] != null) {
                                throw new RuntimeException("assertion failed");
                            }
                        }
                    }
                    if (!thisRow[x]) {
                        if (outline[x] == null) {
                            throw new RuntimeException("assertion failed!");
                        }
                        outline[x].push(x, y + 1);
                    }
                } else {
                    if (prevRow[x + 1]) {
                        if (outline[x] == null) {
                            if (outline[x + 1] == null) {
                                Outline outline2 = new Outline();
                                outline[x + 1] = outline2;
                                outline[x] = outline2;
                                outline[x].push(x, y);
                                outline[x].push(x + 1, y);
                            } else {
                                outline[x] = outline[x + 1];
                                outline[x + 1] = null;
                                outline[x].shift(x, y);
                            }
                        } else if (outline[x + 1] == null) {
                            outline[x + 1] = outline[x];
                            outline[x] = null;
                            outline[x + 1].push(x + 1, y);
                        } else if (outline[x + 1] == outline[x]) {
                            polygons.add(outline[x].getPolygon());
                            outline[x + 1] = null;
                            outline[x] = null;
                        } else {
                            outline[x].push(outline[x + 1]);
                            x1 = 0;
                            while (x1 <= this.w) {
                                if (x1 != x + 1 && outline[x1] == outline[x + 1]) {
                                    outline[x1] = outline[x];
                                    outline[x + 1] = null;
                                    outline[x] = null;
                                    break;
                                }
                                ++x1;
                            }
                            if (outline[x] != null) {
                                throw new RuntimeException("assertion failed");
                            }
                        }
                    }
                    if (thisRow[x]) {
                        if (outline[x] == null) {
                            throw new RuntimeException("assertion failed");
                        }
                        outline[x].shift(x, y + 1);
                    }
                }
                ++x;
            }
            IJ.showProgress(y + 1, this.h + 1);
            ++y;
        }
        IJ.showStatus("Turning into path");
        GeneralPath path = new GeneralPath(0);
        int i = 0;
        while (i < polygons.size()) {
            path.append((Polygon)polygons.get(i), false);
            ++i;
        }
        return new ShapeRoi(path);
    }

    public int setup(String arg, ImagePlus imp) {
        this.image = imp;
        return 141;
    }

    static class Outline {
        int[] x = new int[this.reserved];
        int[] y = new int[this.reserved];
        int first = 5;
        int last = 5;
        int reserved = 10;
        final int GROW = 10;

        private void needs(int newCount, int offset) {
            if (newCount > this.reserved || offset > this.first) {
                if (newCount < this.reserved + 10 + 1) {
                    newCount = this.reserved + 10 + 1;
                }
                int[] newX = new int[newCount];
                int[] newY = new int[newCount];
                System.arraycopy(this.x, 0, newX, offset, this.last);
                System.arraycopy(this.y, 0, newY, offset, this.last);
                this.x = newX;
                this.y = newY;
                this.first += offset;
                this.last += offset;
                this.reserved = newCount;
            }
        }

        public void push(int x, int y) {
            this.needs(this.last + 1, 0);
            this.x[this.last] = x;
            this.y[this.last] = y;
            ++this.last;
        }

        public void shift(int x, int y) {
            this.needs(this.last + 1, 10);
            --this.first;
            this.x[this.first] = x;
            this.y[this.first] = y;
        }

        public void push(Outline o) {
            int count = o.last - o.first;
            this.needs(this.last + count, 0);
            System.arraycopy(o.x, o.first, this.x, this.last, count);
            System.arraycopy(o.y, o.first, this.y, this.last, count);
            this.last += count;
        }

        public void shift(Outline o) {
            int count = o.last - o.first;
            this.needs(this.last + count + 10, count + 10);
            this.first -= count;
            System.arraycopy(o.x, o.first, this.x, this.first, count);
            System.arraycopy(o.y, o.first, this.y, this.first, count);
        }

        public Polygon getPolygon() {
            int count = this.last - this.first;
            int[] x1 = new int[count];
            int[] y1 = new int[count];
            System.arraycopy(this.x, this.first, x1, 0, count);
            System.arraycopy(this.y, this.first, y1, 0, count);
            return new Polygon(x1, y1, count);
        }

        public String toString() {
            String res = "(first:" + this.first + ",last:" + this.last + ",reserved:" + this.reserved + ":";
            if (this.last > this.x.length) {
                System.err.println("ERROR!");
            }
            int i = this.first;
            while (i < this.last && i < this.x.length) {
                res = String.valueOf(res) + "(" + this.x[i] + "," + this.y[i] + ")";
                ++i;
            }
            return String.valueOf(res) + ")";
        }
    }
}

