/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.ByteProcessor;
import java.awt.Color;

public class BinaryProcessor
extends ByteProcessor {
    private ByteProcessor parent;
    static final int OUTLINE = 0;

    public BinaryProcessor(ByteProcessor ip) {
        super(ip.getWidth(), ip.getHeight(), (byte[])ip.getPixels(), ip.getColorModel());
        this.setRoi(ip.getRoi());
        this.parent = ip;
    }

    void process(int type, int count) {
        int inc = this.roiHeight / 25;
        if (inc < 1) {
            inc = 1;
        }
        int bgColor = 255;
        if (this.parent.isInvertedLut()) {
            bgColor = 0;
        }
        byte[] pixels2 = (byte[])this.parent.getPixelsCopy();
        int v = 0;
        int rowOffset = this.width;
        int y = this.yMin;
        while (y <= this.yMax) {
            int offset = this.xMin + y * this.width;
            int p2 = pixels2[offset - rowOffset - 1] & 0xFF;
            int p3 = pixels2[offset - rowOffset] & 0xFF;
            int p5 = pixels2[offset - 1] & 0xFF;
            int p6 = pixels2[offset] & 0xFF;
            int p8 = pixels2[offset + rowOffset - 1] & 0xFF;
            int p9 = pixels2[offset + rowOffset] & 0xFF;
            int x = this.xMin;
            while (x <= this.xMax) {
                int p1 = p2;
                p2 = p3;
                p3 = pixels2[offset - rowOffset + 1] & 0xFF;
                int p4 = p5;
                p5 = p6;
                p6 = pixels2[offset + 1] & 0xFF;
                int p7 = p8;
                p8 = p9;
                p9 = pixels2[offset + rowOffset + 1] & 0xFF;
                switch (type) {
                    case 0: {
                        v = p5;
                        if (v == bgColor || p1 == bgColor || p2 == bgColor || p3 == bgColor || p4 == bgColor || p6 == bgColor || p7 == bgColor || p8 == bgColor || p9 == bgColor) break;
                        v = bgColor;
                    }
                }
                this.pixels[offset++] = (byte)v;
                ++x;
            }
            if (y % inc == 0) {
                this.parent.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
            }
            ++y;
        }
        this.parent.hideProgress();
    }

    public void skeletonize() {
        int pixelsRemoved;
        int[] nArray = new int[256];
        nArray[3] = 1;
        nArray[6] = 1;
        nArray[7] = 3;
        nArray[10] = 3;
        nArray[11] = 1;
        nArray[12] = 1;
        nArray[14] = 1;
        nArray[15] = 3;
        nArray[24] = 2;
        nArray[26] = 2;
        nArray[28] = 3;
        nArray[30] = 3;
        nArray[31] = 3;
        nArray[40] = 3;
        nArray[56] = 2;
        nArray[60] = 3;
        nArray[62] = 2;
        nArray[63] = 2;
        nArray[96] = 2;
        nArray[104] = 2;
        nArray[108] = 2;
        nArray[112] = 3;
        nArray[120] = 3;
        nArray[124] = 3;
        nArray[126] = 2;
        nArray[130] = 3;
        nArray[131] = 1;
        nArray[134] = 1;
        nArray[135] = 3;
        nArray[143] = 1;
        nArray[159] = 1;
        nArray[160] = 3;
        nArray[161] = 1;
        nArray[176] = 2;
        nArray[192] = 2;
        nArray[193] = 3;
        nArray[194] = 1;
        nArray[195] = 3;
        nArray[198] = 1;
        nArray[199] = 3;
        nArray[207] = 1;
        nArray[224] = 2;
        nArray[225] = 3;
        nArray[227] = 1;
        nArray[231] = 1;
        nArray[240] = 3;
        nArray[241] = 3;
        nArray[243] = 1;
        nArray[248] = 2;
        nArray[249] = 2;
        nArray[252] = 2;
        int[] table = nArray;
        int pass = 0;
        do {
            this.setColor(Color.white);
            if (this.roiX == 0) {
                this.moveTo(0, 0);
                this.lineTo(0, this.height - 1);
            }
            if (this.roiY == 0) {
                this.moveTo(0, 0);
                this.lineTo(this.width - 1, 0);
            }
            if (this.roiWidth == this.width) {
                this.moveTo(this.width - 1, 0);
                this.lineTo(this.width - 1, this.height - 1);
            }
            if (this.roiHeight == this.height) {
                this.moveTo(0, this.height - 1);
                this.lineTo(this.width, this.height - 1);
            }
            this.snapshot();
            pixelsRemoved = this.thin(pass++, table);
            this.snapshot();
        } while ((pixelsRemoved = this.thin(pass++, table)) > 0);
    }

    int thin(int pass, int[] table) {
        int inc = this.roiHeight / 25;
        if (inc < 1) {
            inc = 1;
        }
        int bgColor = 255;
        if (this.parent.isInvertedLut()) {
            bgColor = 0;
        }
        byte[] pixels2 = (byte[])this.getPixelsCopy();
        int rowOffset = this.width;
        int pixelsRemoved = 0;
        int count = 100;
        int y = this.yMin;
        while (y <= this.yMax) {
            int offset = this.xMin + y * this.width;
            int x = this.xMin;
            while (x <= this.xMax) {
                int p5 = pixels2[offset] & 0xFF;
                int v = p5;
                if (v != bgColor) {
                    int p1 = pixels2[offset - rowOffset - 1] & 0xFF;
                    int p2 = pixels2[offset - rowOffset] & 0xFF;
                    int p3 = pixels2[offset - rowOffset + 1] & 0xFF;
                    int p4 = pixels2[offset - 1] & 0xFF;
                    int p6 = pixels2[offset + 1] & 0xFF;
                    int p7 = pixels2[offset + rowOffset - 1] & 0xFF;
                    int p8 = pixels2[offset + rowOffset] & 0xFF;
                    int p9 = pixels2[offset + rowOffset + 1] & 0xFF;
                    int index = 0;
                    if (p1 != bgColor) {
                        index |= 1;
                    }
                    if (p2 != bgColor) {
                        index |= 2;
                    }
                    if (p3 != bgColor) {
                        index |= 4;
                    }
                    if (p6 != bgColor) {
                        index |= 8;
                    }
                    if (p9 != bgColor) {
                        index |= 0x10;
                    }
                    if (p8 != bgColor) {
                        index |= 0x20;
                    }
                    if (p7 != bgColor) {
                        index |= 0x40;
                    }
                    if (p4 != bgColor) {
                        index |= 0x80;
                    }
                    int code = table[index];
                    if ((pass & 1) == 1) {
                        if (code == 2 || code == 3) {
                            v = bgColor;
                            ++pixelsRemoved;
                        }
                    } else if (code == 1 || code == 3) {
                        v = bgColor;
                        ++pixelsRemoved;
                    }
                }
                this.pixels[offset++] = (byte)v;
                ++x;
            }
            if (y % inc == 0) {
                this.showProgress((double)(y - this.roiY) / (double)this.roiHeight);
            }
            ++y;
        }
        this.hideProgress();
        return pixelsRemoved;
    }

    public void outline() {
        this.process(0, 0);
    }
}

