/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.arcgrid;

import it.geosolutions.imageio.plugins.arcgrid.AsciiGridsImageMetadata;
import it.geosolutions.imageio.plugins.arcgrid.raster.AsciiGridRaster;
import it.geosolutions.imageio.plugins.arcgrid.spi.AsciiGridsImageReaderSpi;
import it.geosolutions.imageio.utilities.Utilities;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.RasterFactory;

public final class AsciiGridsImageReader
extends ImageReader {
    private static final Logger LOGGER = Logger.getLogger(AsciiGridsImageReader.class.toString());
    private boolean hasListeners;
    private static final int MIN_SIZE_NEED_TILING = 0x500000;
    private static final int DEFAULT_TILE_SIZE = 524288;
    private int width = -1;
    private int height = -1;
    private int imageSize = -1;
    private boolean isTiled = false;
    private int tileWidth = -1;
    private int tileHeight = -1;
    private AsciiGridRaster rasterReader = null;
    private static final ComponentColorModel cm = RasterFactory.createComponentColorModel((int)5, (ColorSpace)ColorSpace.getInstance(1003), (boolean)false, (boolean)false, (int)1);
    private SampleModel sm;
    private ImageTypeSpecifier imageType;
    private ImageInputStream imageInputStream = null;
    private AsciiGridsImageMetadata metadata;

    public AsciiGridsImageReader(AsciiGridsImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void setInput(Object input) {
        IllegalArgumentException ex;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Setting Input");
        }
        if (this.imageInputStream != null) {
            this.reset();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Resetting old stream");
            }
        }
        if (input instanceof ImageInputStream) {
            this.imageInputStream = (ImageInputStream)input;
        } else if (input instanceof URL) {
            URL testUrl = (URL)input;
            if (!testUrl.getProtocol().equalsIgnoreCase("file")) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.severe("Unsupported URL provided as input!");
                }
                throw new IllegalArgumentException("Unsupported URL provided as input!");
            }
            File inFile = Utilities.urlToFile((URL)testUrl);
            if (!inFile.exists()) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.severe("Input file does not exists!");
                }
                throw new IllegalArgumentException("Input file does not exists!");
            }
        } else if (input instanceof File) {
            File inFile = (File)input;
            if (!inFile.exists()) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.severe("Input file does not exists!");
                }
                throw new IllegalArgumentException("Input file does not exists!");
            }
        } else {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.severe("Input is not decodable!");
            }
            throw new IllegalArgumentException("Input is not decodable!");
        }
        if (this.imageInputStream == null) {
            try {
                this.imageInputStream = ImageIO.createImageInputStream(input);
                if (this.imageInputStream == null) {
                    throw new IllegalArgumentException("Unsupported object provided as input!");
                }
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
                ex = new IllegalArgumentException();
                ex.initCause(e);
                throw ex;
            }
        }
        try {
            this.imageInputStream.reset();
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
            ex = new IllegalArgumentException("Unable to parse the header for the provided input");
            ex.initCause(e);
            throw ex;
        }
        this.imageInputStream.mark();
        try {
            this.rasterReader = AsciiGridRaster.AsciiGridRasterType.ESRI.createAsciiGridRaster(this.imageInputStream, this);
            this.rasterReader.parseHeader();
        }
        catch (IOException e) {
            try {
                this.rasterReader = AsciiGridRaster.AsciiGridRasterType.GRASS.createAsciiGridRaster(this.imageInputStream, this);
                this.rasterReader.parseHeader();
            }
            catch (IOException e1) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, e1.getLocalizedMessage(), e1);
                }
                IllegalArgumentException ex2 = new IllegalArgumentException("Unable to parse the header for the provided input");
                ex2.initCause(e1);
                throw ex2;
            }
        }
        super.setInput(this.imageInputStream, true, false);
        this.hasListeners = this.progressListeners != null && !this.progressListeners.isEmpty();
        this.initializeReader();
    }

    private void initializeReader() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.info("Data Initializing");
            LOGGER.info("\tImageInputStream: \t" + this.imageInputStream.toString());
            LOGGER.info("\tRasterType:\t\t\t " + this.rasterReader.getRasterType().toString());
        }
        this.width = this.rasterReader.getNCols();
        this.height = this.rasterReader.getNRows();
        int sampleSizeBit = cm.getPixelSize();
        int sampleSizeByte = (sampleSizeBit + 7) / 8;
        this.imageSize = this.width * this.height * sampleSizeByte;
        if (this.imageSize >= 0x500000) {
            this.isTiled = true;
            this.tileWidth = this.width;
            this.tileHeight = 524288 / (this.tileWidth * sampleSizeByte);
            if (this.tileHeight < 1) {
                this.tileHeight = 1;
            }
            this.sm = cm.createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.rasterReader.setTilesSize(this.tileWidth, this.tileHeight);
        } else {
            this.tileWidth = this.width;
            this.tileHeight = this.height;
        }
        this.sm = cm.createCompatibleSampleModel(this.tileHeight, this.tileWidth);
        this.imageType = new ImageTypeSpecifier(cm, this.sm);
    }

    private void checkImageIndex(int imageIndex) {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException("illegal Index: " + imageIndex);
        }
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return this.height;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return this.width;
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    @Override
    public synchronized Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>();
        if (this.imageType == null) {
            this.imageType = new ImageTypeSpecifier(cm, this.sm);
        }
        l.add(this.imageType);
        return l.iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        if (this.metadata == null) {
            this.metadata = new AsciiGridsImageMetadata(this.rasterReader);
        }
        return this.metadata;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.info("read(final int imageIndex, ImageReadParam param)");
        }
        this.checkImageIndex(imageIndex);
        if (this.hasListeners) {
            this.clearAbortRequest();
            this.processImageStarted(0);
        }
        BufferedImage bi = new BufferedImage(cm, (WritableRaster)this.readRaster(imageIndex, param), false, null);
        if (this.hasListeners) {
            if (this.rasterReader.isAborting()) {
                this.processReadAborted();
            } else {
                this.processImageComplete();
            }
        }
        return bi;
    }

    @Override
    public int getTileHeight(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return this.tileHeight;
    }

    @Override
    public int getTileWidth(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return this.tileWidth;
    }

    @Override
    public boolean isImageTiled(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return this.isTiled;
    }

    @Override
    public boolean isRandomAccessEasy(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        return false;
    }

    @Override
    public boolean isSeekForwardOnly() {
        return true;
    }

    @Override
    public BufferedImage read(int imageIndex) throws IOException {
        this.checkImageIndex(imageIndex);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.info("read(imageIndex");
        }
        return this.read(imageIndex, null);
    }

    @Override
    public boolean readerSupportsThumbnails() {
        return false;
    }

    @Override
    public Raster readRaster(int imageIndex, ImageReadParam param) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.info("readRaster(final int imageIndex, ImageReadParam param)");
        }
        if (param == null) {
            param = this.getDefaultReadParam();
        }
        return this.rasterReader.readRaster(param);
    }

    @Override
    public BufferedImage readTile(int imageIndex, int tileX, int tileY) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.info("readTile(final int imageIndex, final int tileX, final int tileY)");
        }
        this.checkImageIndex(imageIndex);
        int w = this.getWidth(imageIndex);
        int h = this.getHeight(imageIndex);
        int tw = this.getTileWidth(imageIndex);
        int th = this.getTileHeight(imageIndex);
        int x = tw * tileX;
        int y = th * tileY;
        if (tileX < 0 || tileY < 0 || x >= w || y >= h) {
            throw new IllegalArgumentException("Tile indices are out of bounds!");
        }
        if (x + tw > w) {
            tw = w - x;
        }
        if (y + th > h) {
            th = h - y;
        }
        ImageReadParam param = this.getDefaultReadParam();
        Rectangle tileRect = new Rectangle(x, y, tw, th);
        param.setSourceRegion(tileRect);
        return this.read(imageIndex, param);
    }

    @Override
    public Raster readTileRaster(int imageIndex, int tileX, int tileY) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.info("readTileRaster(final int imageIndex, int tileX, int tileY)");
        }
        return this.readTile(imageIndex, tileX, tileY).getRaster();
    }

    @Override
    public boolean canReadRaster() {
        return true;
    }

    @Override
    public int getMinIndex() {
        return 0;
    }

    @Override
    public int getNumThumbnails(int imageIndex) throws IOException {
        return 0;
    }

    @Override
    public boolean hasThumbnails(int imageIndex) throws IOException {
        return false;
    }

    @Override
    public boolean isIgnoringMetadata() {
        return this.ignoreMetadata;
    }

    public AsciiGridRaster getRasterReader() {
        return this.rasterReader;
    }

    public ImageInputStream getCurrentImageInputStream() {
        return this.imageInputStream;
    }

    @Override
    public void dispose() {
        if (this.imageInputStream != null) {
            try {
                this.imageInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.imageInputStream = null;
        super.dispose();
    }

    @Override
    public void reset() {
        this.dispose();
        super.setInput(null, false, false);
        this.rasterReader = null;
        this.tileWidth = -1;
        this.tileHeight = -1;
        this.height = -1;
        this.width = -1;
        this.sm = null;
        this.isTiled = false;
        this.imageType = null;
        this.imageSize = -1;
        this.metadata = null;
    }

    @Override
    public void processImageProgress(float percentageDone) {
        super.processImageProgress(percentageDone);
    }

    @Override
    public synchronized void abort() {
        if (this.rasterReader != null) {
            this.rasterReader.abort();
        }
    }

    @Override
    protected synchronized boolean abortRequested() {
        return this.rasterReader.isAborting();
    }

    @Override
    protected synchronized void clearAbortRequest() {
        if (this.rasterReader != null) {
            this.rasterReader.clearAbort();
        }
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        this.setInput(input);
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly) {
        this.setInput(input);
    }

    public boolean isHasListeners() {
        return this.hasListeners;
    }
}

