# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Chloe
                                 A QGIS plugin
 The chloe history
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2018-11-08
        copyright            : (C) 2018 by Chloecompagny
        email                : Chloecompagny@Chloecompagny.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

__author__ = 'Jean-Charles Naud/Alkante'
__date__ = '2018-11-08'
__copyright__ = '(C) 2018 by Chloecompagny'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '$Format:%H$'

from qgis.core import *
from qgis.PyQt.QtCore import *
from qgis.PyQt.QtGui import *

import os
import sys
import inspect
import locale

# from .chloe_provider import ChloeProvider
from .ChloeAlgorithmProvider import ChloeAlgorithmProvider

cmd_folder = os.path.split(inspect.getfile(inspect.currentframe()))[0]

if cmd_folder not in sys.path:
    sys.path.insert(0, cmd_folder)


class ChloePlugin(object):

    def __init__(self):
        # i18n
        pluginPath = QFileInfo(os.path.realpath(
            __file__)).path()  # patch by Régis Haubourg

        loc = QSettings().value('locale/userLocale')
        if len(loc) == 5:
            localeName = loc
        elif len(loc) == 2:
            localeName = locale.locale_alias[loc].split('.')[0]
        else:
            localeName = QLocale.system().name()

        if QFileInfo(pluginPath).exists():
            self.localePath = pluginPath+os.sep+"i18n"+os.sep+"Chloe_" + localeName + ".qm"
        if QFileInfo(self.localePath).exists():
            self.translator = QTranslator()
            self.translator.load(self.localePath)
            if qVersion() > '4.3.3':
                QCoreApplication.installTranslator(self.translator)

        self.provider = None

    def initProcessing(self):
        """Init Processing provider for QGIS >= 3.8."""
        self.provider = ChloeAlgorithmProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

    def initGui(self):
        self.initProcessing()

    def unload(self):
        QgsApplication.processingRegistry().removeProvider(self.provider)
